; Questo programma serve a generare una forma d'onda periodica ; la forma
; del segnale all'interno di un periodo e' arbitraria, nel senso che puo'
; essere decisa dall'utente, il quale non deve fare altro che riempire
; una certa zona di memoria coi campioni del segnale desiderato.
;
; Utilizzo i nomi standard per i registri mappati in memoria
	.mmregs
;
; Qui dichiaro tutte le variabili necessarie
;
	.ds     0f00h           ; Inizio della memoria dati
TA      .word   9              ; TA AIC value - Fcut = 555.5 kHz
RA      .word   9              ; RA AIC value - Fcut = 555.5 kHz
TB      .word   31              ; TB AIC value - Fs = 15.8 kHz (era 35)
RB      .word   31              ; RB AIC value - Fs = 15.8 kHz (era 35)
AIC_CTR .word   28h              ; |LP xx G1 G0 | SY AX LB BP|
				; +------------+------------+
				;  |     GAIN    |  |  |  +-- BP Filter
				;  |     Synch --+  |  +----- Loopback
				;  |     Auxin -----+
				;  + (sinx)/x filter
; Scrivo 4 numeri a partire dall'inizio del buffer circolare
; serviva per motivi di test.
	 .ds 0f10h        ; inizio del buffer circolare
	 .word 1000h
	 .word 1000h
	 .word 1000h
	 .word 1000h
;
	.ps     080ah           ; Imposto il vettore delle interruzioni
;
; Salta a RX quando avviene un interrupt in ricezione
RINT    b       RX
;
; Salta a TX quando avviene un interrupt in trasmissione
XINT    b       TX
;
	.ps 0a00h               ; Scrivo in memoria programma
	.entry                  ; Punto di inizio dell'esecuzione
	.text                   ; Indico che e' sezione di codice
;
; Inizializzazione del processore, che viene fatta una sola volta
; all'atto della partenza del programma
START   setc    INTM            ; Disable interrupts
	ldp     #0              ; Set data page pointer to page zero
	splk    #0834h,PMST     ; Write 16 bit pattern to PMST register
	lacc    #0              ; Load accumulator with number zero
	;-----------------------;
	samm    CWSR            ; Set software wait state to zero
	samm    PDWSR           ; Set software wait state to zero
	splk    #022h,IMR       ; Using XINT syn TX & RX
	call    AIC             ; Initialize AIC and enable interrupts
	;-----------------------;
	clrc    OVM             ; Overflow mode is set to zero
	spm     0               ; Product shift mode is set to zero
	splk    #012h,IMR       ; Mask interrupts
; Qua preparo per l'uso il buffer circolare
; carico nell'accumulatore l'indirizzo iniziale del buffer circolare
	lacc    #0f10h
; scrivo tale valore nel registro di inizio del buffer circolare
	samm    CBSR1
; scrivo lo stesso valore nel registro che usero' come puntatore
; al buffer circolare. In tal modo il registro punta all'inizio del buffer.
	samm    AR6            ; valore iniziale del puntatore
; Le due istruzioni seguenti NON le eseguiamo da qui, ma da programma C ;
; esse servono ad indicare dove deve finire il buffer circolare.
;	lacc    #1310h
;	samm    CBER1

; Abilito questo buffer circolare e uso AR6 come puntatore
	lacc    #000eh
	samm    CBCR
; Questa istruzione indica che si deve usare il registro AR6 per
; l'indirizzamento che sfrutta i registri ausiliari.
	mar     *,AR6         ; uso il registro AR6.....
	clrc    INTM            ; Enable interrupts
; La parte seguente e' un ciclo infinito da cui il processore esce e
; rientra grazie alle interruzioni che provengono dall'AIC
WAIT    idle                    ; Aspetta l'arrivo di una interruzione
	nop                     ; nessuna operazione
	nop                     ; nessuna operazione
	b       WAIT            ; torna all'inizio
;
; Questa e' la routine che viene eseguita quando avviene un interrupt
; di ricezione.
; Sembra strano, ma se non metto una istruzione vuota l'assemblatore mi
; da' uno strano avvertimento.....
RX      nop                     ; nessuna operazione
;  carico il valore zero nell'accumulatore
	lacc    #0
; sommo all'accumulatore il valore contenuto nella locazione di memoria
; puntata dal registro AR6, sposto il tutto di due bit a sinistra
; e incremento di 1 il valore di AR6
	add     *+,2
; Azzero i due bit meno significativi dell'accumulatore
	and     #0FFFCh
; scrivo il contenuto dell'accumulatore nel registro di uscita (DXR)
	ldp     #0
	samm    DXR
	rete                    ; Ritorno dalla interruzione
;
; Questa e' la routine che viene eseguita quando avviene un interrupt
; di trasmissione. Non esegue niente.
TX      rete                    ; Ritorna dall'interruzione
;
; Le seguenti routines servono ad inizializzare l'AIC
; con i valori voluti.
AIC     splk    #20h,TCR        ; To generate 10 MHz from Tout
	splk    #01h,PRD        ; Load period counter with 1
	mar     *,AR0           ; Modify AR pointer (used with GREG)
	lacc    #0008h          ; Load acc with 08h
	sacl    SPC             ; Store acc in SPC
	lacc    #00C8h          ; Load acc with 0C8h
	sacl    SPC             ; Set and reset SPC register
	;-----------------------;
	lacc    #080h           ; Initialise 8000h to FFFFh as global memory
	sach    DXR             ; Store high acc to DXR
	sacl    GREG            ; Store to global memory register
	lar     AR0,#0FFFFh     ; Set AR0 register
	rpt     #10000          ; Set repeat counter
	lacc    *,0,AR0         ; Access global memory
	sach    GREG            ; Disable global memory
	;-----------------------;
	ldp     #TA             ; Load data page TA
	setc    SXM             ; Set SXM for sign extension mode
	lacc    TA,9            ; Load accumulator with TA data
	add     RA,2            ; Load accumulator with RA data
	call    AIC2ND          ; Call function AIC2ND
	;-----------------------;
	ldp     #TB             ; Load data page TB
	lacc    TB,9            ; Load accumulator with TB data
	add     RB,2            ; Load accumulator with RB data
	add     #02h            ; Add 10b to set status bits
	call    AIC2ND          ; Call function AIC2ND
	;-----------------------;
	ldp     #AIC_CTR        ; Load data page AIC_CTR
	lacc    AIC_CTR,2       ; Initialized control register
	add     #03h            ; Add 11b to set status bits
	call    AIC2ND          ; Call function AIC2ND
	ret                     ; Return from call
;-------------------------------;
AIC2ND  ldp     #0              ; Load data page zero
	sach    DXR             ; Store upper acc to DXR
	clrc    INTM            ; Enable interrupts
	idle                    ; Idle until interrupt - TINT
	add     #6h,15          ; Set 2 LSBs of upper acc high
	sach    DXR             ; Store upper acc to DXR
	idle                    ; Idle until interrupt - TINT
	sacl    DXR             ; Store lower acc to DXR
	idle                    ; Idle until interrupt - TINT
	lacl    #0              ; Store lower acc to DXR - flushing
	sacl    DXR             ; make sure the word got sent
	idle                    ; Idle until interrupt - TINT                   
	setc    INTM            ; Disable interrupts
	ret                     ; Return from call
;-------------------------------;                      
	.end                    ; End of program
